﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Zmiana wartości rezydualnej</title>
	<script runat="server">
		void Dokument_OnLoad(Object sender, EventArgs args)
		{
			ZmianaWartosciRezydualnej dokument = (ZmianaWartosciRezydualnej)DataContext1.Get(typeof(ZmianaWartosciRezydualnej));
			SrodekTrwalyBaseHistoria hist = dokument.SrodekTrwaly[dokument.DataOperacji];

			ReportHeader1.Title = String.Format(
				ReportHeader1.Title,
				hist.WybierzNazwe("Zmiana wartości rezydualnej środka trwałego", "Zmiana wartości rezydualnej wartości niematerialnej/prawnej", "Zmiana wartości rezydualnej wyposażenia"),
				dokument.Numer, dokument.Data, dokument.DataOperacji, dokument.Tytul);

			DataLabelNrInw.EditValue = hist.Srodek.NumerInwentarzowy;
			DataLabelNazwa.EditValue = hist.Srodek.Nazwa;
			DataLabelOpis.EditValue = hist.Srodek.Opis;
			DataLabelKST.EditValue = hist.KRST.Symbol;
			DataLabelNrFabryczny.EditValue = hist.Srodek.NumerFabryczny;
		}

	</script>
</head>
<body>
	<form id="Dokument" method="post" runat="server">
		<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.SrodkiTrwale.ZmianaWartosciRezydualnej,Soneta.Ksiega" OnContextLoad="Dokument_OnLoad" />
		<cc1:ReportHeader id="ReportHeader1" runat="server" title="{0} {1} | Data: {2}, Data operacji: {3} | Tytuł: {4}" />

		<table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="20%" />
			<colgroup width="30%" />
			<colgroup width="20%" />
			<colgroup width="30%" />
			<tr>
				<td><font face="Tahoma" size="2">Nr inwentarzowy:</font></td>
				<td><ea:DataLabel id="DataLabelNrInw" EncodeHTML="true" runat="server" /></td>
				<td><font face="Tahoma" size="2">Nazwa:</font></td>
				<td><ea:DataLabel id="DataLabelNazwa" EncodeHTML="true" runat="server" /></td>
			</tr>
			<tr>
				<td><font face="Tahoma" size="2">KŚT:</font></td>
				<td><ea:DataLabel id="DataLabelKST" EncodeHTML="true" runat="server" /></td>
				<td><font face="Tahoma" size="2">Nr fabryczny:</font></td>
				<td><ea:DataLabel id="DataLabelNrFabryczny" EncodeHTML="true" runat="server" />&nbsp;</td>
			</tr>
			<tr>
				<td style="height: 23px"><font face="Tahoma" size="2">Opis:</font></td>
				<td colspan="3" style="height: 23px"><ea:DataLabel id="DataLabelOpis" EncodeHTML="true" runat="server" />&nbsp;</td>
			</tr>
		</table>

		<p />
		<div style="font-weight: bold; font-size: 8pt; width: 100%; font-family: Verdana">
			Zmiana wartości rezydualnej
		</div>
		<p />
	
		<table id="Table2" cellspacing="0" cellpadding="1" width="100%" border="1">
			<colgroup width="20%" />
			<colgroup width="30%" />
			<colgroup width="20%" />
			<tr>
				<td style="width: 20%"><span style="font-size: 10pt; font-family: Tahoma">&nbsp; </span>	</td>
				<td style="width: 23%; text-align: center;">	<font face="Tahoma" size="2">Nowa wartość rezydualna</font></td>
				<td style="text-align: center"><span style="font-size: 10pt; font-family: Tahoma">Poprzednia wartość rezydualna</span></td>
			</tr>
			<tr>
				<td style="height: 23px; width: 20%;"><span style="font-size: 10pt; font-family: Tahoma">Metoda:</span></td>
				<td style="width: 23%; height: 23px;" align="right"><ea:DataLabel ID="DataLabel1" runat="server" DataMember="MetodaWRMSR"></ea:DataLabel></td>
				<td style="height: 23px" align="right"><ea:DataLabel ID="DataLabel2" runat="server" DataMember="PrevMetodaWRMSR"></ea:DataLabel></td>
			</tr>
			<tr>
				<td style="height: 23px; width: 20%;"><span style="font-size: 10pt; font-family: Tahoma">Współczynnik:</span></td>
				<td style="width: 23%; height: 23px;" align="right"><ea:DataLabel ID="DataLabel3" runat="server" DataMember="WspolczynnikWRMSR"></ea:DataLabel></td>
				<td style="height: 23px" align="right"><ea:DataLabel ID="DataLabel4" runat="server" DataMember="PrevWspolczynnikWRMSR"></ea:DataLabel></td>
			</tr>
			<tr>
				<td style="height: 23px; width: 20%;"><span style="font-size: 10pt; font-family: Tahoma">Wartość:</span></td>
				<td style="width: 23%; height: 23px;" align="right"><ea:DataLabel ID="DataLabel5" runat="server" DataMember="WartoscWRMSR"></ea:DataLabel></td>
				<td style="height: 23px" align="right"><ea:DataLabel ID="DataLabel6" runat="server" DataMember="PrevWartoscWRMSR"></ea:DataLabel></td>
			</tr>
		</table>

		<cc1:ReportFooter id="ReportFooter1" runat="server">
			<subtitles>
				<cc1:FooterSubtitle Caption="Uwagi" Width="100" runat="server" />
				<cc1:FooterSubtitle Caption="Zlecił" Width="45" runat="server" SubtitleType="Podpis" />
				<cc1:FooterSubtitle Caption="Wykonał" runat="server" SubtitleType="Podpis" Width="45" />
			</subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

